/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef WAITERLOCK_H
#define WAITERLOCK_H

#include "qrkcore_global.h"

#include <QHash>
#include <QMutex>
#include <QObject>
#include <QWaitCondition>

class QRK_EXPORT WaiterLock : public QObject {
    Q_OBJECT

public:
    enum WaiterLockType { ADDIMAT = 0, DALLAS };

    WaiterLock(QObject *parent = Q_NULLPTR);
    ~WaiterLock();
    void setData(WaiterLockType type, const QString &portName, int waitTimeout);
    QString getTypeValue(WaiterLockType type);
    QString getKeyValue();

    void run();

signals:
    void request(const QString &s);
    void error(const QString &s);
    void timeout(const QString &s);

private:
    QString m_portName;
    QString m_response;
    int m_waitTimeout = 0;
    QByteArray m_requestData;
    QMutex m_mutex;
    bool m_quit = false;
    QString m_lastrequest;
    int m_waiterlocktype;
    QHash<int, QByteArray> m_waiterlockids;
};

#endif // WAITERLOCK_H
