/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "fontselector.h"
#include "ui_fontselector.h"

FontSelector::FontSelector(QFont font, QWidget *parent)
    : QDialog(parent)
    , ui(new Ui::FontSelector)
{
    ui->setupUi(this);

    // this->font = new QFont(font);
    connect(ui->OKButton, &QPushButton::clicked, this, &FontSelector::accept);
    connect(ui->CancelButton, &QPushButton::clicked, this, &FontSelector::close);

    connect(ui->pointSizeSlider, &QSlider::valueChanged, this, &FontSelector::pointSizeSlider_valueChanged);
    connect(ui->pointSizeSpinBox, static_cast<void (QDoubleSpinBox::*)(double)>(&QDoubleSpinBox::valueChanged), this,
        &FontSelector::pointSizeSpinBox_valueChanged);
    connect(ui->stretchSpinBox, static_cast<void (QSpinBox::*)(int)>(&QSpinBox::valueChanged), this,
        &FontSelector::stretchSpinBox_valueChanged);
    connect(ui->stretchSlider, &QSlider::valueChanged, this, &FontSelector::stretchSlider_valueChanged);
    connect(ui->weight_check, &QCheckBox::stateChanged, this, &FontSelector::weight_check_checked);
    connect(ui->fontComboBox, &QFontComboBox::currentFontChanged, this, &FontSelector::fontComboBox_currentFontChanged);

    ui->fontComboBox->setCurrentFont(font);
    ui->fontComboBox->setCurrentText(font.family());
    ui->pointSizeSpinBox->setValue(font.pointSize());
    ui->stretchSpinBox->setValue(font.stretch());
    ui->weightLabel->setHidden(true);
    ui->weight_check->setHidden(true);
}

FontSelector::~FontSelector()
{
    delete ui;
}

void FontSelector::pointSizeSlider_valueChanged(int v)
{
    ui->pointSizeSpinBox->setValue(v / 100.0);
    update();
}

void FontSelector::pointSizeSpinBox_valueChanged(double v)
{
    QFont f = ui->sampleText->font();
    f.setPointSizeF(v);
    ui->sampleText->setFont(f);
    ui->pointSizeSlider->setValue((int)(v * 100));
    update();
}

void FontSelector::stretchSpinBox_valueChanged(int v)
{
    QFont f = ui->sampleText->font();
    f.setStretch(v);
    ui->sampleText->setFont(f);
    update();
}

void FontSelector::stretchSlider_valueChanged(int v)
{
    ui->stretchSpinBox->setValue(v);
    update();
}

void FontSelector::weight_check_checked(bool checked)
{
    QFont f = ui->sampleText->font();
    f.setBold(checked);
    ui->sampleText->setFont(f);
    update();
}

void FontSelector::fontComboBox_currentFontChanged(const QFont &f)
{
    ui->sampleText->setFont(f);
    update();
    ui->pointSizeSlider->setValue(f.pointSize());
    ui->pointSizeSpinBox->setValue(f.pointSizeF());
}

void FontSelector::update()
{
    const QFont &f = ui->sampleText->font();
    ui->stretchSpinBox->setValue(f.stretch());
    ui->stretchSlider->setValue(f.stretch());
    ui->weight_check->setChecked(f.bold());
}

void FontSelector::accept()
{
    QDialog::accept();
}

QFont FontSelector::getFont()
{
    return ui->sampleText->font();
}
