/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright 2010, Martin Koller, kollix@aon.at
 *
 */

#include "3rdparty/ckvsoft/preferences/settings.h"
#include "3rdparty/profeatures/profeatures.h"
#include "backup.h"

#include "wsdlbackup.h"
#include "wsdlbackupsettings.h"

WsdlBackup::WsdlBackup()
{
    m_root = new QDialog();
    m_enabled = ProFeatures::isValid();
}

WsdlBackup::~WsdlBackup()
{
}

bool WsdlBackup::process(int idx)
{
    Q_UNUSED(idx)
    if (m_enabled) Backup::create();
    return true;
}

void WsdlBackup::setupUi()
{
    WsdlBackupSettings *wsdlbackupsettings = new WsdlBackupSettings();

    QPushButton *pushButton = new QPushButton;
    pushButton->setMinimumHeight(60);
    pushButton->setMinimumWidth(0);

    QIcon icon = QIcon(":icons/ok.png");
    QSize size = QSize(32, 32);
    pushButton->setIcon(icon);
    pushButton->setIconSize(size);
    pushButton->setText(tr("OK"));

    QGroupBox *buttonGroup = new QGroupBox();
    QHBoxLayout *buttonLayout = new QHBoxLayout;
    QSpacerItem *spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Expanding);
    buttonLayout->addItem(spacer);
    buttonLayout->addWidget(pushButton);
    buttonGroup->setLayout(buttonLayout);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(wsdlbackupsettings);
    mainLayout->addLayout(buttonLayout);
    m_root->setLayout(mainLayout);

    m_root->setWindowTitle(tr("Backup/Restore Plugin"));
    m_root->setMinimumWidth(700);

    if (QApplication::desktop()->height() < 650) {
        //        pushButton->setMinimumHeight(0);
        m_root->setFixedHeight(550);
    }

    pushButton->setMinimumHeight(60);

    connect(wsdlbackupsettings, &WsdlBackupSettings::accept, m_root, &QDialog::accept);
}

QDialog *WsdlBackup::SettingsDialog()
{
    setupUi();
    m_enabled = ProFeatures::isValid();
    return m_root;
}

bool WsdlBackup::isActivated()
{
    if (m_enabled) {
        Settings settings;
        return settings.value("WsdlBackup/backup_enabled", false).toBool();
    }
    return false;
}
