/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#include "csqlquery.h"

#include <QApplication>
#include <QDebug>
#include <QMapIterator>
#include <QSqlError>

CSqlQuery::CSqlQuery(const QSqlDatabase &db, const QString &pretty_function)
    : QSqlQuery(db)
    , m_pretty_funktion(pretty_function)
{
}

CSqlQuery::CSqlQuery()
    : QSqlQuery()
{
}


bool CSqlQuery::exec()
{
    bool ok = QSqlQuery::exec();
    bool debugSql = qApp->property("debugSql").toBool();

    if (!ok && m_show_error) {
        if (m_is_critical) {
            qCritical() << "Function Name: " << m_pretty_funktion << " Error: " << lastError().text();
            qCritical() << "Function Name: " << m_pretty_funktion << " Query: " << getLastExecutedQuery();
        } else {
            qWarning() << "Function Name: " << m_pretty_funktion << " Error: " << lastError().text();
            qWarning() << "Function Name: " << m_pretty_funktion << " Query: " << getLastExecutedQuery();
        }
    } else if (debugSql) {
        qDebug() << "Function Name: " << m_pretty_funktion << " Query: " << getLastExecutedQuery();
    }
    m_show_error = true;
    m_is_critical = false;
    return ok;
}

bool CSqlQuery::exec(const QString &queryStr)
{
    prepare(queryStr);
    return CSqlQuery::exec();
}

QString CSqlQuery::getLastExecutedQuery() const
{
    QString str = lastQuery();
    QMapIterator<QString, QVariant> it(boundValues());
    it.toBack();

    while (it.hasPrevious()) {
        it.previous();
        str.replace(it.key(), it.value().toString());
    }

    return str;
}

void CSqlQuery::setShowError(bool show)
{
    m_show_error = show;
}
void CSqlQuery::setCriticalError(bool isCritical)
{
    m_is_critical = isCritical;
}
