/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "dialog.h"

#include <QLineEdit>
#include <QRegularExpressionValidator>

Dialog::Dialog(QWidget *parent)
    : QDialog(parent)
{
}

void Dialog::registerMandatoryField(QLineEdit *le, const QString &regexp)
{
    if (!le || m_mandatoryFields.contains(le)) return;

    if (regexp != "") {
        le->setValidator(new QRegularExpressionValidator(QRegularExpression(regexp), le));
    }

    m_mandatoryFields.append(le);

    QObject::connect(le, &QLineEdit::textChanged, this, &Dialog::checkLineEdits);
}

void Dialog::unregisterMandatoryField(QLineEdit *le)
{
    if (!le || !m_mandatoryFields.contains(le)) return;

    QObject::disconnect(le, Q_NULLPTR, Q_NULLPTR, Q_NULLPTR);

    m_mandatoryFields.removeAll(le);
}

void Dialog::checkLineEdits()
{
    bool b = true;

    for (QList<QLineEdit *>::iterator iter = m_mandatoryFields.begin(); iter != m_mandatoryFields.end(); ++iter) {
        QLineEdit *le = *iter;

        if (le == Q_NULLPTR) continue;

        if (le->text().isEmpty() || !le->hasAcceptableInput()) {
            b = false;
            break;
        }
    }

    emit hasAcceptableInput(b);
}
