/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
/*
 * This file is part of ckvsoft
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DRAGFLOWWIDGET_H
#define DRAGFLOWWIDGET_H

#include "../flowlayout.h"
#include "../globals_ckvsoft.h"

#include <QWidget>

class QDragEnterEvent;
class QDropEvent;
class DragPushButton;
class QButtonGroup;

class CKVSOFT_EXPORT DragFlowWidget : public QWidget {
    Q_OBJECT

public:
    explicit DragFlowWidget(const QString &mimeType, QWidget *parent = Q_NULLPTR);
    ~DragFlowWidget() override;
    void addWidget(DragPushButton *button);
    DragPushButton *getDragPushButton(int id);

protected:
    void dragEnterEvent(QDragEnterEvent *event) override;
    void dragMoveEvent(QDragMoveEvent *event) override;
    void dropEvent(QDropEvent *event) override;

signals:
    void buttonClicked(int id);
    void orderChanged(QList<int> indexList);

private:
    QString dragflowMimeType()
    {
        return m_mimeType; /* QStringLiteral("application/x-dragflow"); */
    }
    void mouseLongPressEvent(QPoint pos);
    void hover(QPoint pos, bool drop = false);
    void createDrag(const QPoint &pos, QWidget *widget);
    QList<int> indexList();

    FlowLayout *m_flowlayout = Q_NULLPTR;
    QButtonGroup *m_buttonGroup = Q_NULLPTR;
    QWidget *m_current = Q_NULLPTR;
    QString m_stylesheet;
    QString m_mimeType;
};

#endif // QRKWIDGET_H
