/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef REGISTRATIONTAB_H
#define REGISTRATIONTAB_H

#include "../verification.h"
#include "../widget.h"

#include "../globals_ckvsoft.h"

#include <QJsonObject>

class QLabel;
class QCheckBox;
class PushButton;

class CKVSOFT_EXPORT RegistrationTab : public Widget {
    Q_OBJECT
public:
    RegistrationTab(const QString &appname, bool showActivateMessageBox = true, QWidget *parent = Q_NULLPTR);
    bool isValid(int &days);
    void setAlternateWebJsonData(QJsonObject jsonObjectData);
    void setShowActivateMessageBox(bool testing = true);
    void callWeb(bool renew = false);
    void callWebRenew();
    static bool isActive(const QString &name);
    static bool isActive(const QString &name, QString &strValue);
    static void setActive(const QString &name);
    static void setActive(const QString &name, QString &strValue);

private:
    QJsonObject loadLicense();
    Verification *m_verification = Q_NULLPTR;
    void saveLicense();
    void loadLicenseFromFile();
    void loadLicenseFromServer();
    void Verify();
    void checkBoxChecked(bool checked);
    void activateMessageBox();
    int getDemoDays(int valid);

    QString m_name = "QRK-PRO";
    QString m_alternatewebjsondata = "";
    QJsonObject m_license;
    bool m_isValid = false;
    bool m_showActivateMessageBox = true;

    QCheckBox *m_activateCheckBox;
    PushButton *m_webBuyPushButton;
    PushButton *m_webRenewPushButton;
    QLabel *m_serialnumber;
    QLabel *m_nameLabel;
    QLabel *m_expirydate;
    QLabel *m_signature;
    QLabel *m_validto;
    QLabel *m_textlabel;
    int m_demodays = -1;
    QString m_serial = 0;
};

#endif // REGISTRATIONTAB_H
