/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "qrksettings.h"
#include "3rdparty/ckvsoft/csqlquery.h"
#include "database.h"
#include "qrkjournal.h"

#include <QApplication>
#include <QDebug>
#include <QFile>
#include <QSettings>
#include <QSqlError>


QrkSettings::QrkSettings(QObject *parent)
    : Settings(parent)
{
    m_journal = new QrkJournal(this);
}

QrkSettings::~QrkSettings()
{
}

void QrkSettings::save2Database(QString name, QString value)
{

    QSqlDatabase dbc = Database::database();
    CSqlQuery query(dbc, Q_FUNC_INFO);

    QVariant oldValue;
    QString oldStrValue;
    Database::select_globals(name, oldValue, oldStrValue);

    if ((oldStrValue.isEmpty() && !value.isEmpty()) || oldStrValue != value) {
        Database::insert2globals(name, QVariant(), value);
        globalStringValues.insert(name, value);
        QString text;
        if (name == "version")
            text = QString("Softwareupdate von Version '%1' auf Version '%2'")
                       .arg(Database::getLastVersionInfo())
                       .arg(value);
        else
            text = QString("Parameter '%1' aus der Datenbanktabelle 'globals' wurde "
                           "von '%2' auf '%3' geändert")
                       .arg(name)
                       .arg(oldStrValue)
                       .arg(value);
        m_journal->journalInsertLine("Konfigurationsänderung", text);
    }
}

void QrkSettings::save2Settings(QString name, QVariant value, bool journaling)
{
    QVariant oldValue = m_settings->value(name);
    if (oldValue != value) {
        m_settings->setValue(name, value);
        Database::updateGlobals(name, Q_NULLPTR, Q_NULLPTR);
        QString text = QString("Parameter '%1' aus der Konfigurationsdatei wurde "
                               "von '%2' auf '%3' geändert")
                           .arg(name)
                           .arg(oldValue.toString())
                           .arg(value.toString());
        if (journaling) m_journal->journalInsertLine("Konfigurationsänderung", text);
    }
}

void QrkSettings::removeSettings(QString name, bool journaling)
{
    QVariant oldValue = m_settings->value(name);
    if (oldValue.isValid()) {
        QString text = QString("Parameter '%1' aus der Konfigurationsdatei wurde "
                               "von '%2' auf 'standard' geändert")
                           .arg(name)
                           .arg(oldValue.toString());
        if (journaling) m_journal->journalInsertLine("Konfigurationsänderung", text);
    }

    QString f = m_settings->fileName();

    m_settings->remove(name);
}
