/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "qrkgastrocurfewchecker.h"
#include "database.h"

#include <QDateTime>
#include <QDebug>

QrkGastroCurfewChecker::QrkGastroCurfewChecker(QObject *parent)
    : QObject(parent)
    , m_timer(Q_NULLPTR)
{
}

QrkGastroCurfewChecker::~QrkGastroCurfewChecker()
{
    m_timer->stop();
    emit finished();
}

void QrkGastroCurfewChecker::run()
{
    m_timer = new QTimer(this);
    connect(m_timer, &QTimer::timeout, this, &QrkGastroCurfewChecker::getCurfewDiff);
    qDebug() << "Function Name: " << Q_FUNC_INFO << "timer start: " << m_timer;
    m_timer->start(2000);
    qInfo() << "Function Name: " << Q_FUNC_INFO << " Timer started: " << m_timer->interval();
}

void QrkGastroCurfewChecker::getCurfewDiff()
{
    qDebug() << "Function Name: " << Q_FUNC_INFO << "timer stop: " << m_timer;
    m_timer->stop();

    int diff = 0;
    QDateTime current = QDateTime::currentDateTime();
    QTime curfew = Database::getCurfewTime();
    if (current.time() > curfew) {
        diff = current.time().secsTo(QTime(23, 59, 59));
        diff = diff + QTime(0, 0, 0).secsTo(curfew);
    } else {
        diff = current.time().secsTo(curfew);
    }

    if (diff <= 1800) {
        emit curFew(diff);
        m_timer->start(180000);
        qInfo() << "Function Name: " << Q_FUNC_INFO << " Timer started: " << m_timer->interval();
    } else {
        m_timer->start((diff - 1800) * 1000);
        qInfo() << "Function Name: " << Q_FUNC_INFO << " Timer started: " << m_timer->interval();
    }
}
