#
# This file is part of QRK - Qt Registrier Kasse
#
# Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Button Design, and Idea for the Layout are lean out from LillePOS, Copyright 2010, Martin Koller, kollix@aon.at
#
#

#-------------------------------------------------
#
# Project created by QtCreator 2015-11-27T11:30:17
#
#-------------------------------------------------

include(../defaults.pri)

QT += sql
QT += printsupport
QT += widgets
QT += network
QT += serialport

CONFIG += c++11
CONFIG += silent

# The following define makes your compiler emit warnings if you use
# any feature of Qt which as been marked as deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS
DEFINES += QT_MESSAGELOGCONTEXT

# You can also make your code fail to compile if you use deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0

DESTDIR = ../../bin

RESOURCES += \
    ../../qrk.qrc

INCLUDEPATH += $$SRC_DIR/qrkgastro
INCLUDEPATH += $$SRC_DIR/qrkcore
INCLUDEPATH += $$SRC_DIR/qrkcore/ckvsoft
DEPENDPATH += $$SRC_DIR/qrkcore

include(base/base.pri)

win32:CONFIG(release, debug|release): LIBS += -L../../qrkcore/release -lQrkCore
else:win32:CONFIG(debug, debug|release): LIBS += -L../../qrkcore/debug -lQrkCore
else:unix: LIBS += -L../../qrkcore -lQrkCore

win32|macx {
    # Fervor autoupdater
    # (set TARGET and VERSION of your app before including Fervor.pri)
    !include("base/3rdparty/fervor-autoupdate/Fervor.pri") {
	error("Unable to include Fervor autoupdater.")
    }
    DEFINES += FV_GUI

    DEFINES += FV_APP_NAME=\\\"$$TARGET\\\"
    DEFINES += FV_APP_VERSION=\\\"$$VERSION\\\"
}

# qeasysettings
win32 {
 !include("base/3rdparty/qeasysettings/qeasysettings.pri") {
    error("Unable to include QEasySettings.")
 }
}

# qtsingleapplication
!include("base/3rdparty/qtsingleapplication/qtsingleapplication.pri") {
   error("Unable to include QtSingleApplication.")
}

unix:!macx {
 INCLUDEPATH += /usr/include/PCSC
 LIBS += -lpcsclite
}

macx {
 INCLUDEPATH += /usr/local/include
 #INCLUDEPATH += /usr/local/Cellar/qrencode/3.4.4/include
 QMAKE_LFLAGS += -Wl,-rpath,@executable_path/
 LIBS += -L/usr/local/lib
 LIBS += -framework PCSC
 LIBS += -framework CoreFoundation
 ICON = ../../qrk.icns
}

win32 {
 INCLUDEPATH += $$[QT_INSTALL_PREFIX]/include/QtZlib
 LIBS += libwinscard
 LIBS += -pthread
 RC_ICONS = ../../qrk.ico
}

LIBS += -lcryptopp
LIBS += -lz

win32:CONFIG(release, debug|release): COREDLL = $$BUILD_DIR/../qrkcore/release/*.dll
else:win32:CONFIG(debug, debug|release): COREDLL = $$BUILD_DIR/../qrkcore/debug/*.dll
else:macx: COREDLL = $$BUILD_DIR/../../qrkcore/libQrkCore.1.0.0.dylib

win32: PLUGINS = $$BUILD_DIR/../plugins/bin/*.dll
else:macx: PLUGINS = $$BUILD_DIR/../../plugins/bin/*.dylib

macx {
QMAKE_POST_LINK += $$quote($(COPY_FILE) $$COREDLL $$BUILD_DIR/../../bin/$${TARGET}.app/Contents/MacOS/libQrkCore.1.dylib) &
QMAKE_POST_LINK += $$quote($(MKDIR) $$BUILD_DIR/../../bin/$${TARGET}.app/Contents/plugins) &
QMAKE_POST_LINK += $$quote($(COPY_DIR) $$PLUGINS $$BUILD_DIR/../../bin/$${TARGET}.app/Contents/plugins/) &
QMAKE_POST_LINK += install_name_tool -change libQrkCore.1.dylib  @executable_path/libQrkCore.1.dylib $$BUILD_DIR/../../bin/$${TARGET}.app/Contents/MacOS/$${TARGET} &
} else:win32 {
#QMAKE_POST_LINK += $$shell_path($(COPY_DIR) $$COREDLL $$BUILD_DIR/../bin/) &
#QMAKE_POST_LINK += $$shell_path($(MKDIR) $$BUILD_DIR/../bin/plugins) &
#QMAKE_POST_LINK += $$shell_path($(COPY_DIR) $$PLUGINS $$BUILD_DIR/../bin/plugins/)
}

message(Qt version: $$[QT_VERSION])
message(Qt is installed in $$[QT_INSTALL_PREFIX])
message(Qt resources can be found in the following locations:)
message(Documentation: $$[QT_INSTALL_DOCS])
message(Header files: $$[QT_INSTALL_HEADERS])
message(Libraries: $$[QT_INSTALL_LIBS])
message(Binary files (executables): $$[QT_INSTALL_BINS])
message(Plugins: $$[QT_INSTALL_PLUGINS])
message(Data files: $$[QT_INSTALL_DATA])
message(Translation files: $$[QT_INSTALL_TRANSLATIONS])
message(BuildDir: $$BUILD_DIR)
