/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#include "settingswidget.h"

#include <QCheckBox>
#include <QEvent>
#include <QJsonObject>
#include <QLineEdit>
#include <QMessageBox>

SettingsWidget::SettingsWidget(QWidget *parent)
    : Widget(parent)
{
}

bool SettingsWidget::maybeSave()
{
    if (isModified()) {
        QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, accessibleName(),
            tr("Einige Eigenschaften wurden geändert.\nMöchten Sie die Änderungen "
               "speichern?"),
            QMessageBox::Save | QMessageBox::Cancel);
        if (ret == QMessageBox::Save)
            return true; // save();
        else if (ret == QMessageBox::Cancel)
            return false;
    }
    return true;
}

bool SettingsWidget::isModified()
{
    m_ismodified = m_initialData != m_jsonValues;
    return m_ismodified;
}
