SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";

START TRANSACTION;

-- 1. receipts
-- Adds the unix_timestamp column to the receipts table.
ALTER TABLE `receipts` ADD COLUMN `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP(NOW()));
-- Updates existing rows using the value from the 'timestamp' column.
UPDATE `receipts` SET `unix_timestamp` = UNIX_TIMESTAMP(`timestamp`) WHERE `unix_timestamp` IS NULL OR `unix_timestamp` = 0;


-- 2. tickets
-- Adds the unix_timestamp column to the tickets table.
ALTER TABLE `tickets` ADD COLUMN `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP(NOW()));
-- Updates existing rows using the value from the 'timestamp' column.
UPDATE `tickets` SET `unix_timestamp` = UNIX_TIMESTAMP(`timestamp`) WHERE `unix_timestamp` IS NULL OR `unix_timestamp` = 0;


-- 3. journal
-- Adds the unix_timestamp column to the journal table.
ALTER TABLE `journal` ADD COLUMN `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP(NOW()));
-- Updates existing rows using the value from the 'datetime' column.
UPDATE `journal` SET `unix_timestamp` = UNIX_TIMESTAMP(`datetime`) WHERE `unix_timestamp` IS NULL OR `unix_timestamp` = 0;


-- 4. history
-- Adds the unix_timestamp column to the history table.
ALTER TABLE `history` ADD COLUMN `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP(NOW()));
-- Updates existing rows using the value from the 'datetime' column.
UPDATE `history` SET `unix_timestamp` = UNIX_TIMESTAMP(`datetime`) WHERE `unix_timestamp` IS NULL OR `unix_timestamp` = 0;


-- 5. reports
-- Adds the unix_timestamp column to the reports table.
ALTER TABLE `reports` ADD COLUMN `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP(NOW()));
-- Updates existing rows using the value from the 'timestamp' column.
UPDATE `reports` SET `unix_timestamp` = UNIX_TIMESTAMP(`timestamp`) WHERE `unix_timestamp` IS NULL OR `unix_timestamp` = 0;


-- 6. Index Cleanup (We ONLY drop potential old indexes, but skip CREATE INDEX to avoid errors)
-- Note: We only execute the safe DROP IF EXISTS
DROP INDEX IF EXISTS `orders_receiptId_index` ON `orders`;
DROP INDEX IF EXISTS `orders_ticketId_index` ON `ticketorders`;
DROP INDEX IF EXISTS `orderdescs_orderId_index` ON `orderdescs`;
DROP INDEX IF EXISTS `receipts_stornoId_index` ON `receipts`;
DROP INDEX IF EXISTS `receiptspay_index` ON `receiptspay`;
-- The CREATE INDEX commands are now omitted.


COMMIT;

SET FOREIGN_KEY_CHECKS=1;
