#
# This file is part of QRK - Qt Registrier Kasse
#
# Copyright (C) 2015-2024 Christian Kvasny <chris@ckvsoft.at>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Button Design, and Idea for the Layout are lean out from LillePOS, Copyright 2010, Martin Koller, kollix@aon.at
#
#

INCLUDEPATH += "$$PWD"

HEADERS += $$PWD/ckvtemplate.h \
    $$PWD/RK/a_signacos_04.h \
    $$PWD/RK/a_signacos_ID.h \
    $$PWD/RK/a_signcardos_53.h \
    $$PWD/RK/a_signonline.h \
    $$PWD/RK/a_signsmardcard.h \
    $$PWD/RK/base32decode.h \
    $$PWD/RK/base32encode.h \
    $$PWD/RK/rk_signaturemodule.h \
    $$PWD/RK/rk_signaturemodulefactory.h \
    $$PWD/RK/rk_signatureonline.h \
    $$PWD/RK/rk_signaturesmartcard.h \
    $$PWD/RK/rk_smartcardinfo.h \
    $$PWD/abstractdatabase.h \
    $$PWD/csqlquery.h \
    $$PWD/customtoolbutton.h \
    $$PWD/databasedefinition.h \
    $$PWD/databasemanager.h \
    $$PWD/deprecation_warnings.h \
    $$PWD/dialog.h \
    $$PWD/globals_ckvsoft.h \
    $$PWD/headerproxy.h \
    $$PWD/horizontalscrollarea.h \
    $$PWD/journal.h \
    $$PWD/multilistcombobox.h \
    $$PWD/networkutils.h \
    $$PWD/preferences/registrationtab.h \
    $$PWD/preferences/settings.h \
    $$PWD/pushbutton.h \
    $$PWD/qcompressor.h \
    $$PWD/rbac/acl.h \
    $$PWD/rbac/acsinterface.h \
    $$PWD/rbac/crypto.h \
    $$PWD/rbac/useradmin.h \
    $$PWD/rbac/rolesadmin.h \
    $$PWD/rbac/aclmanager.h \
    $$PWD/rbac/permissionsadmin.h \
    $$PWD/rbac/aclwizard.h \
    $$PWD/flowlayout.h \
    $$PWD/rbac/user.h \
    $$PWD/rbac/userlogin.h \
    $$PWD/rbac/resetpassword.h \
    $$PWD/rbac/base_login.h \
    $$PWD/rbac/tempuserlogin.h \
    $$PWD/singleton/Singleton.h \
    $$PWD/singleton/spreadsignal.h \
    $$PWD/size.h \
    $$PWD/sortfiltersqlquerymodel.h \
    $$PWD/uniquemachinefingerprint.h \
    $$PWD/numerickeypad.h \
    $$PWD/headerview.h \
    $$PWD/qsqlrtmodel.h \
    $$PWD/drag/dragflowwidget.h \
    $$PWD/drag/dragpushbutton.h \
    $$PWD/datetimedelegate.h \
    $$PWD/quickbuttons.h \
    $$PWD/delegates/buttoncolumndelegate.h \
    $$PWD/jsontablemodel.h \
    $$PWD/verification.h \
    $$PWD/version.h \
    $$PWD/widget.h \
    $$PWD/texteditdialog.h \
    $$PWD/qlonglongspinbox.h \
    $$PWD/westtabwidget.h \
    $$PWD/naturalsortproxymodel.h

SOURCES += $$PWD/ckvtemplate.cpp \
    $$PWD/RK/a_signacos_04.cpp \
    $$PWD/RK/a_signacos_ID.cpp \
    $$PWD/RK/a_signcardos_53.cpp \
    $$PWD/RK/a_signonline.cpp \
    $$PWD/RK/a_signsmardcard.cpp \
    $$PWD/RK/base32decode.cpp \
    $$PWD/RK/base32encode.cpp \
    $$PWD/RK/rk_signaturemodule.cpp \
    $$PWD/RK/rk_signaturemodulefactory.cpp \
    $$PWD/RK/rk_signatureonline.cpp \
    $$PWD/RK/rk_signaturesmartcard.cpp \
    $$PWD/RK/rk_smartcardinfo.cpp \
    $$PWD/abstractdatabase.cpp \
    $$PWD/csqlquery.cpp \
    $$PWD/customtoolbutton.cpp \
    $$PWD/databasedefinition.cpp \
    $$PWD/databasemanager.cpp \
    $$PWD/dialog.cpp \
    $$PWD/horizontalscrollarea.cpp \
    $$PWD/multilistcombobox.cpp \
    $$PWD/networkutils.cpp \
    $$PWD/preferences/registrationtab.cpp \
    $$PWD/preferences/settings.cpp \
    $$PWD/pushbutton.cpp \
    $$PWD/qcompressor.cpp \
    $$PWD/rbac/acl.cpp \
    $$PWD/rbac/crypto.cpp \
    $$PWD/rbac/useradmin.cpp \
    $$PWD/rbac/rolesadmin.cpp \
    $$PWD/rbac/aclmanager.cpp \
    $$PWD/rbac/permissionsadmin.cpp \
    $$PWD/rbac/aclwizard.cpp \
    $$PWD/flowlayout.cpp \
    $$PWD/rbac/user.cpp \
    $$PWD/rbac/userlogin.cpp \
    $$PWD/rbac/resetpassword.cpp \
    $$PWD/rbac/base_login.cpp \
    $$PWD/rbac/tempuserlogin.cpp \
    $$PWD/singleton/spreadsignal.cpp \
    $$PWD/size.cpp \
    $$PWD/sortfiltersqlquerymodel.cpp \
    $$PWD/uniquemachinefingerprint.cpp \
    $$PWD/numerickeypad.cpp \
    $$PWD/headerview.cpp \
    $$PWD/drag/dragflowwidget.cpp \
    $$PWD/drag/dragpushbutton.cpp \
    $$PWD/datetimedelegate.cpp \
    $$PWD/quickbuttons.cpp \
    $$PWD/delegates/buttoncolumndelegate.cpp \
    $$PWD/jsontablemodel.cpp \
    $$PWD/texteditdialog.cpp \
    $$PWD/naturalsortproxymodel.cpp \
    $$PWD/verification.cpp

FORMS += \
    $$PWD/databasedefinition.ui \
    $$PWD/rbac/base_admin.ui \
    $$PWD/quickbuttons.ui

win32 {
    LIBS += -liphlpapi
}
unix:!macx {
    LIBS += -ludev
}

# qbcmath
!include("qbcmath/qbcmath.pri") {
    error("Unable to include qbcmath.")
}

RESOURCES += \
    $$PWD/ckvsoft.qrc

message(ckvsoft PWD: $$PWD)
