#include "networkutils.h"
#include <QNetworkInterface>

void NetworkUtils::getMacAddresses(QString &mac1, QString &mac2)
{
    mac1 = "0";
    mac2 = "0";

    QList<QNetworkInterface> interfaces = QNetworkInterface::allInterfaces();

    // Sortieren der Interfaces basierend auf der MAC-Adresse
    std::sort(interfaces.begin(), interfaces.end(), [](const QNetworkInterface &a, const QNetworkInterface &b) {
        return a.hardwareAddress() < b.hardwareAddress();
    });

    // Erste gültige MAC-Adressen suchen
    int foundMacs = 0;
    for (int i = 0; i < interfaces.size(); ++i) {
        QNetworkInterface interface = interfaces[i];
        QString macAddress = interface.hardwareAddress();
        if (!macAddress.isEmpty() && macAddress != "00:00:00:00:00:00") {
            if (foundMacs == 0) {
                mac1 = macAddress;
            } else if (foundMacs == 1) {
                mac2 = macAddress;
                break;
            }
            foundMacs++;
        }
    }
}

quint16 NetworkUtils::hashMacAddressFromStrings(const QString &macAddress)
{
    // MAC-Adresse von QString in quint8* (Byte-Array) umwandeln
    QByteArray macByteArray = macAddress.toUtf8();
    quint8 mac[6];

    // Konvertiere die Zeichenkette in das richtige Format (6 Bytes)
    QStringList macParts = macAddress.split(":");
    for (int i = 0; i < 6; ++i) {
        mac[i] = macParts[i].toInt(nullptr, 16);
    }

    // Hash-Berechnung direkt hier
    quint16 hash = 0;
    for (quint32 i = 0; i < 6; i++) {
        hash += (mac[i] << ((i & 1) * 8));
    }

    return hash;
}
