BEGIN TRANSACTION;

CREATE TABLE `printerdefs_backup` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	TEXT NOT NULL UNIQUE,
        `definition`	TEXT NOT NULL
);

INSERT INTO printerdefs_backup SELECT `id`,`name`,`definition` FROM `printerdefs`;

CREATE TABLE `printers_backup` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	TEXT NOT NULL UNIQUE,
        `printer`	TEXT NOT NULL,
        `definition`	INTEGER NOT NULL DEFAULT 1,
        FOREIGN KEY(`definition`) REFERENCES `printerdefs_backup`(`id`)
);
INSERT INTO printers_backup SELECT `id`,`name`,`printer`,`definition` FROM `printers`;
DROP TABLE `printers`;
DROP TABLE `printerdefs`;

CREATE TABLE `printerdefs` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	TEXT NOT NULL UNIQUE,
        `definition`	TEXT NOT NULL,
        `mode`	INTEGER NOT NULL DEFAULT 0
);
INSERT INTO printerdefs SELECT `id`,`name`,`definition`, 0 FROM `printerdefs_backup`;

CREATE TABLE `printers` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	TEXT NOT NULL UNIQUE,
        `printer`	TEXT NOT NULL,
        `definition`	INTEGER NOT NULL DEFAULT 1,
        `mode`	INTEGER NOT NULL DEFAULT 0,
        FOREIGN KEY(`definition`) REFERENCES `printerdefs`(`id`)
);
INSERT INTO printers SELECT `id`,`name`,`printer`,`definition`, 0 FROM `printers_backup`;
DROP TABLE `printers_backup`;
DROP TABLE `printerdefs_backup`;

COMMIT;
