#ifndef SETTINGSWIDGET_H
#define SETTINGSWIDGET_H

#include "3rdparty/ckvsoft/widget.h"

#include <QJsonObject>

class SettingsWidget : public Widget {
    Q_OBJECT
public:
    SettingsWidget(QWidget *parent = Q_NULLPTR);
    bool maybeSave();

protected:
    void setInitial(const QJsonObject &data)
    {
        m_initialData = data;
        set(data);
    }
    void set(const QJsonObject &data)
    {
        m_jsonValues = data;
    }
    void set(const QString &key, const QVariant &value)
    {
        m_jsonValues.insert(key, QJsonValue::fromVariant(value));
    }
    bool isModified();

private:
    QJsonObject get();
    //    virtual bool save() = 0;

    QJsonObject m_jsonValues;
    QJsonObject m_initialData;
    bool m_ismodified = false;
};

#endif // SETTINGSWIDGET_H
