/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef RECEIPTITEMMODEL_H
#define RECEIPTITEMMODEL_H

#include "pluginmanager/Interfaces/wsdlinterface.h"

#include "3rdparty/ckvsoft/csqlquery.h"
#include "3rdparty/ckvsoft/qbcmath/bcmath.h"
#include "qrkcore_global.h"

#include <QDateTime>
#include <QStandardItemModel>

enum NULL_RECEIPT {
    START_RECEIPT = 5,
    CONTROL_RECEIPT,
    COLLECTING_RECEIPT,
    MONTH_RECEIPT,
    CONCLUSION_RECEIPT,
    YEAR_RECEIPT
};

enum CUSTOMDATAROLE { CUSTOMDATA = Qt::DisplayRole + 20 };

/*  5,'Startbeleg'
    6,'Kontrollbeleg'
    7,'Sammelbeleg'
    8,'Monatsbeleg' == 'Jahresbeleg'
    9,'Schlussbeleg'
*/

class QRK_EXPORT ReceiptItemModel : public QStandardItemModel {
    Q_OBJECT
public:
    ReceiptItemModel(QObject *parent = Q_NULLPTR);
    ~ReceiptItemModel();

    QJsonObject compileData(int id = 0);

    void setCurrentReceiptNum(int id);
    void setReceiptTime(QDateTime receiptTime);
    void setCustomerText(const QString &customerText);
    void setAdvertisingText(const QString &advertisingText);
    void newOrder(bool addRow = true);
    void clear();
    void plus();
    void setGiven(QMap<int, double> given);
    void setGiven(int, double);
    void setR2B(bool);
    void setRoomTableName(QString roomname, QString tablename);

    bool setReceiptImportMode(QJsonObject obj);
    bool setR2BImportMode(QJsonObject obj);
    bool createNullReceipt(int title, QString additional_text = "");
    bool createStartReceipt();
    bool finishReceipts(int, int = 0, bool = false);
    void extracted(bool &ret, CSqlQuery &query, CSqlQuery &customquery,
                   CSqlQuery &tktquery, int &row, QString &customData);
    bool createOrder(bool storno = false);
    bool storno(int id);

    int createReceipts();
    int getReceiptNum();
    void setUseDiscount(bool use);
    void setCurrentRow(int row);
    int currentRow();

signals:
    void setButtonGroupEnabled(bool);
    void finishedItemChanged();
    void finishedPlus();
    void not_a_number(const QString &);
    void not_valid_payment(const QString &, const QString &);
    void singlePriceChanged(QString product, QString singleprice, QString tax);
    void futureTimeDetected(QDateTime futurtime);
    void impossibleTotalPrice(const QString &s, const QString &s2);

private slots:
    void itemChangedSlot(const QModelIndex &, const QModelIndex &);

private:
    void setTotallyUp(bool totallyup);
    bool doEndOfDay(QDate date);
    void initPlugins();
    void processPayment(CSqlQuery query, int payedBy, QJsonObject &data);
    void processJsonObject(const QJsonObject &obj, QBCMath total = {});
    int getFreeProductNumber(int number, int currentRow);
    QString getFreeProductNumber(QString number, int currentRow);
    void handleManualProduct(int row);

    WsdlInterface *wsdlInterface = Q_NULLPTR;

    QDate m_lastEOD;
    QString m_currency;
    QString m_taxlocation;
    QString m_customerText;
    QString m_advertisingText;
    QString m_manualProductsNumber = "";
    QString m_roomname = "";
    QString m_tablename = "";

    QDateTime m_receiptTime;
    bool m_isR2B;
    bool m_isReport;
    bool m_totallyup;
    bool m_changeProduct = false;
    bool m_changeProductNumber = false;
    bool m_useDiscount = false;
    bool m_useInputNetPrice = false;

    int m_currentReceipt;
    int m_currentRow;
    QMap<int, double> m_given;
};

#endif // RECEIPTITEMMODEL_H
