#include "qrkwaiterlockacs.h"
#include "3rdparty/ckvsoft/rbac/acl.h"
#include "utils/waiterlock.h"

QrkWaiterLockACS::QrkWaiterLockACS(QDialog *parent)
    : ACSInterface(parent)
{
}

int QrkWaiterLockACS::execute(int userid)
{
    const QString title = tr("Kellnerschloß Zuweisung für %1 ändern").arg(RBAC::Instance()->getUsername(userid));
    setWindowTitle(title);
    m_userid = userid;

    loginLabel->setText(tr("ACS Key"));
    passwordLabel->setHidden(true);
    passwordLineEdit->setHidden(true);
    userLineEdit->setFocus();
    okPushButton->setText(tr("Ändern"));
    cancelPushButton->setText(tr("Zurück"));

    savePasswordCheckBox->setVisible(false);
    windowNameLabel->setText(tr("Kellnerschloß Zuweisung"));
    windowCommentLabel->setText("ACHTUNG: Änderungen müssen danach noch im Manager gespeichert werden.");
    windowCommentLabel->setWordWrap(true);
    programVersionLabel->setText("");
    programVersionNoLabel->setText("");
    logoLabel->setPixmap(QPixmap(":/ckvsoft/resources/icons/password.png").scaled(48, 48, Qt::KeepAspectRatio));

    connect(m_waiterlock, &WaiterLock::request, [this](QString key) {
        userLineEdit->setText(key);
    });
    connect(cancelPushButton, &QPushButton::clicked, this, &QrkWaiterLockACS::reject);
    connect(okPushButton, &QPushButton::clicked, this, &QrkWaiterLockACS::OnChange);
    userLineEdit->setText(m_waiterlock->getKeyValue());
    int rvalue = exec();
    disconnect(m_waiterlock, &WaiterLock::request, Q_NULLPTR, Q_NULLPTR);
    return rvalue;
}

void QrkWaiterLockACS::OnChange()
{
    disconnect(m_waiterlock, &WaiterLock::request, Q_NULLPTR, Q_NULLPTR);

    SecureByteArray acskey = userLineEdit->text().toUtf8();

    Crypto crypto;
    QString cryptAcsKey = crypto.encrypt(acskey, SecureByteArray("acskey"));

    m_acskey = cryptAcsKey;
    QDialog::accept();
    QDialog::close();
}

QString QrkWaiterLockACS::getAcsKey()
{
    return m_acskey;
}

void QrkWaiterLockACS::setWaiterLock(WaiterLock *wl)
{
    m_waiterlock = wl;
}
