#include "currencynumberformatdelegate.h"

CurrencyNumberFormatDelegate::CurrencyNumberFormatDelegate(QObject *parent)
    : QStyledItemDelegate(parent)
{
}

QString CurrencyNumberFormatDelegate::displayText(const QVariant &value, const QLocale &locale) const
{
    QString formattedNum = locale.toString(value.toDouble(), 'f', 2) + " " + locale.currencySymbol();
    return formattedNum;
}

void CurrencyNumberFormatDelegate::paint(
    QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QStyleOptionViewItem alignedOption(option);
    alignedOption.displayAlignment = Qt::AlignRight;
    QStyledItemDelegate::paint(painter, alignedOption, index);
}
