/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef COUPONDIALOG_H
#define COUPONDIALOG_H

#include <QDialog>
#include <QModelIndex>
#include <QSqlQueryModel>

class QSqlTableModel;
class QSqlDatabase;
class QItemSelection;

enum COUPON_TYPE { TYPE_FIRST = -1, TYPE_MULTI, TYPE_SINGLE };

namespace Ui {
class CouponDialog;
}

class CouponDialog : public QDialog {
    Q_OBJECT

public:
    explicit CouponDialog(QDialog *parent = Q_NULLPTR);
    ~CouponDialog();
    static QString getLastEntryDate();
    static QString getLastCheckSum();

protected slots:
    void onStornoButtonClicked();
    void onSelectionChanged(const QItemSelection &, const QItemSelection &);
    void onTableClicked(const QModelIndex &index);

signals:
    void error();

private:
    Ui::CouponDialog *ui;
    QSqlTableModel *m_model = Q_NULLPTR;
    void init();
    void setupView();
    void setUiData();
    void readSettings();
    void writeSettings();
    void insertNew();
    void printFunction(const QString& voucherCode, const QString& info);


    bool checkDatabase();
    void cancelation(int id, QString &description);
    bool dataBaseExists();

    QTimer *m_timer;
    QString m_currency = "";
};

#endif // COUPONDIALOG_H
