/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef PROFEATURES_H
#define PROFEATURES_H

#include "3rdparty/ckvsoft/csqlquery.h"
#include "qrkcore_global.h"
#include "receiptitemmodel.h"
#include <QObject>

class QSqlQueryModel;
class QCheckBox;
class QComboBox;
class QBCMath;

class QRK_EXPORT ProFeatures : public QObject {
public:
    static bool isValid();
    static void setProfeatures(bool);
    static double GroupEditFeatures(QSqlQueryModel *model, int index, bool &ok);
    static void SettingsFeatures(QCheckBox *box, const QString what);
    static void SettingsFeatures(QComboBox *box, const QString what = {});
    static bool CouponDialog(ReceiptItemModel &model, QBCMath &sum, QBCMath &redeem, QString &code, bool &isSingle);
    static bool CouponUpdate(int receiptNum, const QString &code, const QString &topay);
    static bool isActive(const QString &pluginname);
    static QString VersionInfo();

    // database stuff
    static double getTaxFromProduct(const int id);
    static bool getTaxFromGroup(const QString &groupname, QBCMath &tax);
    static QString getCheckoutContents(bool beautify = true);
    static bool updatePluginDatabase(const QString &name, const QString &table_name, int schema, const QString &path);
    static void processCouponPayment(
        CSqlQuery &query, int payedBy, QJsonObject &data, QMap<int, double> &given, int currentReceipt);

    static bool OptionalReciptPrint(QJsonObject &data);

private:
    static bool getProfeatures(bool &value);
};

#endif // PROFEATURES_H
