#ifndef PINDIALOG_H
#define PINDIALOG_H

#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>

#include "globals_ckvsoft.h"

class CKVSOFT_EXPORT PinDialog : public QDialog {
    Q_OBJECT

public:
    explicit PinDialog(QWidget *parent = nullptr);
    void setCardSerial(const QString &serial);
    bool isSuccess() const;

private slots:
    void onAcceptClicked();

private:
    bool storePinInDatabase(const QString &pin);

    QLineEdit *pinEdit1;
    QLineEdit *pinEdit2;
    QLabel *infoLabel;
    QLabel *errorLabel;
    QPushButton *okButton;
    QPushButton *cancelButton;

    QString cardSerial;
    bool success = false;
};

#endif // PINDIALOG_H
