#
# This file is part of QRK - Qt Registrier Kasse
#
# Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Button Design, and Idea for the Layout are lean out from LillePOS, Copyright 2010, Martin Koller, kollix@aon.at
#
#

#-------------------------------------------------
#
# Project created by QtCreator 2015-11-27T11:30:17
#
#-------------------------------------------------

INCLUDEPATH += $$SRC_DIR/qrkgastro
DEFINES += QRK_GASTRO
CONFIG += silent

TARGET = qrk-gastro

include(../qrk.pri)

win32:CONFIG(release, debug|release): LIBS += -L../../qrkgastro/release -lQrkGastro
else:win32:CONFIG(debug, debug|release): LIBS += -L../../qrkgastro/debug -lQrkGastro
else:unix: LIBS += -L../../qrkgastro -lQrkGastro

win32:CONFIG(release, debug|release): {
    LIBS += -L../qrkcore/release -lQrkCore
    GASTRODLL = $$BUILD_DIR/../qrkgastro/release/*.dll
} else:win32:CONFIG(debug, debug|release): {
    LIBS += -L../qrkcore/debug -lQrkCore
    GASTRODLL = $$BUILD_DIR/../qrkgastro/debug/*.dll
} else:macx: {
    GASTRODLL = $$BUILD_DIR/../../qrkgastro/libQrkGastro.1.0.0.dylib
}

macx {
QMAKE_POST_LINK += $$quote($(COPY_FILE) $$GASTRODLL $$BUILD_DIR/../../bin/$${TARGET}.app/Contents/MacOS/libQrkGastro.1.dylib) &
QMAKE_POST_LINK += install_name_tool -change libQrkGastro.1.dylib  @executable_path/libQrkGastro.1.dylib $$BUILD_DIR/../../bin/$${TARGET}.app/Contents/MacOS/$${TARGET} &
} else:win32 {
#QMAKE_POST_LINK += $$shell_path($(COPY_DIR) $$COREDLL $$BUILD_DIR/../bin/) &
#QMAKE_POST_LINK += $$shell_path($(MKDIR) $$BUILD_DIR/../bin/plugins) &
#QMAKE_POST_LINK += $$shell_path($(COPY_DIR) $$PLUGINS $$BUILD_DIR/../bin/plugins/)
}

message(SrcDir: $$SRC_DIR)
