#ifndef PRIMESIGNCARDOS_53_H
#define PRIMESIGNCARDOS_53_H

#include "primesignsmartcard.h"

#include "globals_ckvsoft.h"

#define PRIMESIGN_OS53_CMD_PUT_HASH "\x00\x2A\x9E\x9A\x20" // + 32 byte SHA256

class CKVSOFT_EXPORT PrimeSignCARDOS_53 : public PrimeSignSmartCard {
public:
    PrimeSignCARDOS_53(QString device_name, bool shared = false);
    ~PrimeSignCARDOS_53();

    QString signReceipt(QString data) override;
    QString getCertificateSerial(bool hex = true) override;
    QString getCertificate(bool base64 = true) override;
    QString getCardType() override;
    QString getExpireInfo() override;
    QString getSVI() override
    {
        return "AT3";
    }
    bool verifyPin(bool &blocked) override;


protected:
    bool selectDF_QES();
    void getPrivateKey(unsigned char *pkey);

    ASignResponse signHash(const unsigned char hash[32]) override;
};

#endif // PRIME_SIGNCARDOS_53_H
