#ifndef WAITERLOCK_H
#define WAITERLOCK_H

#include "qrkcore_global.h"

#include <QHash>
#include <QMutex>
#include <QObject>
#include <QWaitCondition>

class QRK_EXPORT WaiterLock : public QObject {
    Q_OBJECT

public:
    enum WaiterLockType { ADDIMAT = 0, DALLAS };

    WaiterLock(QObject *parent = Q_NULLPTR);
    ~WaiterLock();
    void setData(WaiterLockType type, const QString &portName, int waitTimeout);
    QString getTypeValue(WaiterLockType type);
    QString getKeyValue();

    void run();

signals:
    void request(const QString &s);
    void error(const QString &s);
    void timeout(const QString &s);

private:
    QString m_portName;
    QString m_response;
    int m_waitTimeout = 0;
    QByteArray m_requestData;
    QMutex m_mutex;
    bool m_quit = false;
    QString m_lastrequest;
    int m_waiterlocktype;
    QHash<int, QByteArray> m_waiterlockids;
};

#endif // WAITERLOCK_H
