#ifndef HEADERPROXY_H
#define HEADERPROXY_H

#include "globals_ckvsoft.h"

#include <QAbstractProxyModel>

class CKVSOFT_EXPORT HeaderProxy : public QAbstractProxyModel {
    Q_OBJECT

public:
    explicit HeaderProxy(QObject *parent = Q_NULLPTR)
        : QAbstractProxyModel(parent)
    {
    }

    QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const
    {
        if (!parent.isValid())
            return createIndex(row, column);
        return QModelIndex();
    }

    QModelIndex parent(const QModelIndex & /*child*/) const { return QModelIndex(); }

    QModelIndex mapToSource(const QModelIndex &proxyIndex) const
    {
        if (!proxyIndex.isValid())
            return QModelIndex();

        return createIndex(proxyIndex.row(), proxyIndex.column());
    }

    QModelIndex mapFromSource(const QModelIndex &sourceIndex) const
    {
        if (!sourceIndex.isValid())
            return QModelIndex();

        return index(sourceIndex.row(), sourceIndex.column());
    }

    int rowCount(const QModelIndex &parent) const { return sourceModel()->columnCount(parent); }

    int columnCount(const QModelIndex & /*parent*/) const { return 1; }

    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const
    {
        return sourceModel()->headerData(index.row(), Qt::Horizontal, role);
    }

    Qt::ItemFlags flags(const QModelIndex & /* index */) const { return Qt::ItemIsSelectable | Qt::ItemIsEnabled; }
};

#endif // HEADERPROXY_H
