BEGIN TRANSACTION;

CREATE TEMPORARY TABLE `actiontypes_backup` (
        `id`	INTEGER PRIMARY KEY AUTOINCREMENT,
        `actionId`	INTEGER NOT NULL,
        `actionText`	TEXT NOT NULL,
        `comment`	TEXT
);

INSERT INTO `actiontypes_backup` SELECT `id`,`actionId`,`actionText`,`comment` FROM `actionTypes`;
DROP TABLE `actionTypes`;

CREATE TABLE `actiontypes` (
        `id`	INTEGER PRIMARY KEY AUTOINCREMENT,
        `actionId`	INTEGER NOT NULL,
        `actionText`	TEXT NOT NULL,
        `comment`	TEXT
);

INSERT INTO `actiontypes` SELECT `id`,`actionId`,`actionText`,`comment` FROM `actiontypes_backup`;
DROP TABLE `actiontypes_backup`;

CREATE TEMPORARY TABLE `taxtypes_backup` (
        `id`        INTEGER PRIMARY KEY AUTOINCREMENT,
        `tax`       double,
        `comment`   TEXT,
        `taxlocation`   TEXT
);
INSERT INTO `taxtypes_backup` SELECT `id`,`tax`,`comment`,`taxlocation` FROM `taxTypes`;
DROP TABLE `taxTypes`;

CREATE TABLE `taxtypes` (
        `id`        INTEGER PRIMARY KEY AUTOINCREMENT,
        `tax`       double,
        `comment`   TEXT,
        `taxlocation`   TEXT
);
INSERT INTO `taxtypes` SELECT `id`,`tax`,`comment`,`taxlocation` FROM `taxtypes_backup`;
DROP TABLE `taxtypes_backup`;

CREATE TABLE `orderextras_backup` (
  `orderId` INTEGER NOT NULL REFERENCES `ticketorders` (`id`),
  `type` INTEGER,  /* "with" or "without" flag */
  `product` INTEGER NOT NULL REFERENCES `products` (`id`)
);
INSERT INTO `orderextras_backup` SELECT `orderId`,`type`,`product` FROM `orderExtras`;
DROP TABLE `orderExtras`;

CREATE TABLE `orderextras` (
  `orderId` INTEGER NOT NULL REFERENCES `ticketorders` (`id`),
  `type` INTEGER,  /* "with" or "without" flag */
  `product` INTEGER NOT NULL REFERENCES `products` (`id`)
);
CREATE INDEX `orderextras_orderId_index` ON `orderextras` (`orderId`);
INSERT INTO `orderextras` SELECT `orderId`,`type`,`product` FROM `orderextras_backup`;
DROP TABLE `orderextras_backup`;

CREATE TABLE `orderdescs_backup` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `type` INTEGER NOT NULL,
  `orderId` INTEGER NOT NULL,
  `description` TEXT
);
INSERT INTO `orderdescs_backup` SELECT `id`,`type`,`orderId`, `description` FROM `orderDescs`;
DROP TABLE `orderDescs`;

CREATE TABLE `orderdescs` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `type` INTEGER NOT NULL,
  `orderId` INTEGER NOT NULL,
  `description` TEXT
);
CREATE INDEX `orderdescs_orderId_index` ON `orderdescs` (`orderId`);
INSERT INTO `orderdescs` SELECT `id`,`type`,`orderId`, `description` FROM `orderdescs_backup`;
DROP TABLE `orderdescs_backup`;

COMMIT;
