#ifndef PRIMESIGNONLINE_H
#define PRIMESIGNONLINE_H

#include "rk_signatureonline.h"
#include <QtNetwork/QtNetwork>

#include "globals_ckvsoft.h"

class CKVSOFT_EXPORT PrimeSignOnline : public RKSignatureOnline {
public:
    PrimeSignOnline(QString connectionString);
    ~PrimeSignOnline();

    QString signReceipt(QString data) override;
    QString getCertificateSerial(bool hex = true) override;
    QString getCertificate(bool base64 = true) override;
    bool selectApplication() override;
    QString getCardType() override;
    QString getExpireInfo() override
    {
        return QString();
    }
    QString getSVI() override
    {
        return "AT3";
    }

protected:
    bool doRequest(QNetworkRequest &req, QJsonObject &obj);
    QByteArray getRaw(const QUrl &url);
    QString extractBase64FromPEM(const QByteArray &pem);
    bool login();
    bool logout();

private:
    void setAuthHeader(QNetworkRequest &req);

    QNetworkAccessManager *m_manager = nullptr;
    QString m_userid;
    QString m_sharedsecret;
    QString m_url;
    QString m_keyId;
    QString m_certificateSerial;
    QString m_certificateSerialHex;
    QString m_alg;
};

#endif // PRIMESIGNONLINE_H
