/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "cashbooksettingswidget.h"
#include "ui_cashbooksettingswidget.h"

#include "3rdparty/profeatures/profeatures.h"
#include "database.h"

#include <QDateTime>
#include <QDebug>
#include <QFile>
#include <QSqlDatabase>
#include <QSqlError>

#include <QVariant>

CashBookSettingsWidget::CashBookSettingsWidget(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::CashBookSettingsWidget)
{
    ui->setupUi(this);

    QVariant value;
    QString strValue;

    AbstractDataBase::select_globals("cashbook_active", value, strValue);
    ui->groupBox->setChecked(value.toBool());

    //    connect(ui->groupBox, &QGroupBox::toggled, this, &CashBookSettingsWidget::updateDatabase);
    connect(ui->savePushButton, &QrkPushButton::clicked, this, &CashBookSettingsWidget::save);
    connect(ui->exitPushButton, &QrkPushButton::clicked, this, &CashBookSettingsWidget::rejected);

    ui->openingstockLineEdit->setEnabled(false);

    if (cashboxBeginIsEmpty()) ui->openingstockLineEdit->setEnabled(true);
}

CashBookSettingsWidget::~CashBookSettingsWidget()
{
    delete ui;
}

bool CashBookSettingsWidget::cashboxBeginIsEmpty()
{

    QSqlDatabase dbc = AbstractDataBase::database("CASHBOOK");
    if (!dbc.tables(QSql::AllTables).contains(QLatin1String("cashbook"))) return true;

    QVariant value = 0;
    QString strValue = "";

    AbstractDataBase::select_globals("cashbook_begin", value, strValue);
    ui->openingstockLineEdit->setText(QLocale().toString((value.toDouble() / 100), 'f', 2));
    if (strValue.isEmpty()) return true;

    return false;
}

void CashBookSettingsWidget::save()
{

    if (cashboxBeginIsEmpty() && !ui->openingstockLineEdit->text().isEmpty()) {
        AbstractDataBase::insert2globals("cashbook_begin", int(ui->openingstockLineEdit->text().toDouble() * 100),
            QDateTime::currentDateTime().toString(Qt::ISODate));
    }

    if (ui->groupBox->isChecked()) {
        if (updateDatabase(true)) AbstractDataBase::insert2globals("cashbook_active", 1, QVariant());
    } else {
        AbstractDataBase::insert2globals("cashbook_active", 0, QVariant());
    }

    emit saved();
}

bool CashBookSettingsWidget::updateDatabase(bool checked)
{
    if (checked) {
        int current_schema = 1;
        return ProFeatures::updatePluginDatabase(
            "cashbook", QLatin1String("cashbook"), current_schema, ":cashbook/sql/cashbook");
    }

    return true;
}
