CREATE TABLE `actiontypes` (
        `id`	INTEGER PRIMARY KEY AUTOINCREMENT,
        `actionId`	INTEGER NOT NULL,
        `actionText`	TEXT NOT NULL,
        `comment`	TEXT
);

INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,0,'BAR','payedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,1,'Bankomat','payedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,2,'Kreditkarte','payedByText');
INSERT INTO `actionTypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,3,'Gutschein','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,4,'Tagesabschluss','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,5,'Monatsabschluss','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,6,'Startbeleg','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,7,'Kontrollbeleg','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,8,'Sammelbeleg','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,9,'Monatsbeleg','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,10,'Schlussbeleg','PayedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,-1,'Privat','payedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,-2,'Werbung','payedByText');
INSERT INTO `actiontypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,-3,'Personal','payedByText');
INSERT INTO `actionTypes`(`id`,`actionId`,`actionText`,`comment`) VALUES (NULL,11,'Jahresbeleg','PayedByText');


CREATE TABLE `taxtypes` (
        `id`        INTEGER PRIMARY KEY AUTOINCREMENT,
        `tax`       double,
        `comment`   TEXT,
        `taxlocation`   TEXT
);

INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,20.0,'Satz-Normal','AT');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,10.0,'Satz-Ermaessigt-1','AT');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,13.0,'Satz-Ermaessigt-2','AT');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,19.0,'Satz-Besonders','AT');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,0.0,'Satz-Null','AT');

INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,19.0,'Satz-Normal','DE');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,7.0,'Satz-Ermaessigt-1','DE');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,0.0,'Satz-Null','DE');

INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,7.7,'Satz-Normal','CH');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,2.5,'Satz-Ermaessigt-1','CH');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,3.7,'Satz-Besonders','CH');
INSERT INTO `taxtypes`(`id`,`tax`,`comment`,`taxlocation`) VALUES (NULL,0.0,'Satz-Null','CH');

CREATE TABLE `globals` (
    `id`                INTEGER PRIMARY KEY AUTOINCREMENT,
    `name`              text NOT NULL,
    `value`             INTEGER,
    `strValue`          text
);

CREATE TABLE  `rooms` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `name` text NOT NULL,
  `color`      	text DEFAULT '',
  `isHotel` INTEGER NOT NULL DEFAULT 0,
  `sortorder` INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE  `tables` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `roomId` INTEGER NOT NULL,
  `name` text NOT NULL,
  `color`      	text DEFAULT '',
  `sortorder` INTEGER NOT NULL DEFAULT 0,
  CONSTRAINT `room_Id` FOREIGN KEY (`roomId`) REFERENCES `rooms` (`id`)
);

CREATE TABLE  `tickets` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `open` tinyint(1) NOT NULL DEFAULT '1',
  `timestamp` datetime NOT NULL,
  `tableId` int(11) NOT NULL,
  `payedBy` int(11) NOT NULL DEFAULT '0',
  `guestname` TEXT
);

CREATE TABLE  `ticketorders` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `ticketId` INTEGER NOT NULL REFERENCES `tickets` (`id`),
  `product` INTEGER NOT NULL REFERENCES `products` (`id`),
  `count` int(11) NOT NULL DEFAULT '1',
  `gross` double NOT NULL,
  `printed` int(11) NOT NULL DEFAULT '0'
);

CREATE INDEX `orders_ticketId_index` ON `ticketorders` (`ticketId`);

CREATE TABLE "orderextras" (
        "orderId"	INTEGER NOT NULL,
        "ticketId"	INTEGER,
        "type"	INTEGER,
        "product"	INTEGER NOT NULL,
        FOREIGN KEY("orderId") REFERENCES "ticketorders"("id"),
        FOREIGN KEY("product") REFERENCES "products"("id")
);
CREATE INDEX `orders_ticketId_index` ON `ticketorders` (`ticketId`);

CREATE TABLE `orderdescs` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  `type` INTEGER NOT NULL,
  `orderId` INTEGER NOT NULL,
  `description` TEXT
);
CREATE INDEX `orderdescs_orderId_index` ON `orderdescs` (`orderId`);

CREATE TABLE `categories` (
        `id`	INTEGER NOT NULL,
        `name`	text NOT NULL,
        `color`	text DEFAULT '',
        `printerid`	INTEGER DEFAULT NULL,
        `image`	text DEFAULT '',
        `visible`	tinyint(1) NOT NULL DEFAULT 1,
        `sortorder`	INTEGER NOT NULL DEFAULT 0,
        PRIMARY KEY(`id` AUTOINCREMENT)
);
INSERT INTO `categories`(`id`, `name`, `color`) VALUES (1, 'Standard', '#008b8b');

CREATE TABLE "groups" (
        "id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        "name"	text NOT NULL,
        "color"	text DEFAULT '',
        "printerid"	INTEGER DEFAULT NULL,
        "image"	text DEFAULT '',
        "tax"	NUMERIC,
        "visible"	tinyint(1) NOT NULL DEFAULT 1,
        "categoryId"	INTEGER NOT NULL DEFAULT 1,
        "sortorder"	INTEGER NOT NULL DEFAULT 0,
        CONSTRAINT "categoryId" FOREIGN KEY("categoryId") REFERENCES "categories"("id")
);

INSERT INTO `groups`(`id`, `name`,`color`,`visible`) VALUES (1, 'auto', '', 0);
INSERT INTO `groups`(`id`, `name`,`color`,`visible`) VALUES (2, 'Standard', '#008b8b', 1);

CREATE TABLE `products` (
    `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `itemnum`	text NOT NULL,
    `barcode`	text NOT NULL,
    `name`	text NOT NULL,
    `sold`	double NOT NULL DEFAULT 0,
    `net`	double NOT NULL,
    `gross`	double NOT NULL,
    `groupid`	INTEGER NOT NULL DEFAULT 2,
    `visible`	tinyint(1) NOT NULL DEFAULT 1,
    `completer`	tinyint(1) NOT NULL DEFAULT 1,
    `tax`	double NOT NULL DEFAULT '20',
    `color`     text DEFAULT '#808080',
    `button`    text DEFAULT '',
    `image`     text DEFAULT '',
    `coupon`	tinyint(1) NOT NULL DEFAULT 0,
    `stock`	double NOT NULL DEFAULT 0,
    `minstock`	double NOT NULL DEFAULT 0,
    `version`	INTEGER NOT NULL DEFAULT 0,
    `origin`	INTEGER NOT NULL DEFAULT 0,
    `lastchange` TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    `description`	text,
    `sortorder` INTEGER NOT NULL DEFAULT 0,
    `printerid` INTEGER DEFAULT NULL,
    CONSTRAINT `groupid` FOREIGN KEY (`groupid`) REFERENCES `groups` (`id`)
);

CREATE TABLE `orders` (
    `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `receiptId`	INTEGER NOT NULL,
    `product` INTEGER NOT NULL,
    `count`	double NOT NULL DEFAULT '1',
    `discount`	double NOT NULL DEFAULT '0',
    `net`	double NOT NULL,
    `gross`	double NOT NULL,
    `tax`	double NOT NULL DEFAULT '0.0',
    CONSTRAINT `product` FOREIGN KEY(`product`) REFERENCES `products` ( `id` )
);

CREATE INDEX `orders_receiptId_index` ON `orders` (`receiptId`);

CREATE TABLE `receipts` (
    `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `timestamp`	datetime NOT NULL,
    `infodate`	datetime NOT NULL,
    `receiptNum`	INTEGER DEFAULT NULL,
    `payedBy`	INTEGER NOT NULL DEFAULT '0',
    `gross`	double NOT NULL DEFAULT '0',
    `r2b`	INTEGER NOT NULL DEFAULT '0',
    `storno`	INTEGER NOT NULL DEFAULT '0',
    `stornoId`	INTEGER NOT NULL DEFAULT '0',
    `userId`	INTEGER NOT NULL DEFAULT '0',
    `current_hash` TEXT,
    `previous_hash` TEXT,
    `isprinted` INTEGER DEFAULT '1'
);

CREATE INDEX `receipts_stornoId_index` ON `receipts` (`stornoId`);

CREATE TABLE `receiptspay` (
    `receiptNum`	INTEGER DEFAULT NULL,
    `payedBy`	INTEGER NOT NULL DEFAULT '0',
    `gross`	double NOT NULL DEFAULT '0'
);

CREATE INDEX `receiptspay_index` ON `receiptspay` (`receiptNum`);

CREATE TABLE `customer` (
    `id`                INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `receiptNum`	INTEGER DEFAULT NULL,
    `text`              text
);

CREATE TABLE `history` (
    `id`                INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `datetime`          datetime NOT NULL,
    `data`              text,
    `userId`            INTEGER NOT NULL DEFAULT '0'
);

CREATE TABLE `journal` (
    `id`                INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `version`           text NOT NULL,
    `cashregisterid`    text NOT NULL,
    `datetime`          datetime NOT NULL,
    `data`              text,
    `checksum`          text,
    `userId`            INTEGER NOT NULL DEFAULT '0'
);

CREATE TABLE `dep` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `receiptNum`	INTEGER,
        `data`	text
);

CREATE TABLE certs (
    id       INTEGER PRIMARY KEY AUTOINCREMENT,
    serial   TEXT UNIQUE NOT NULL,
    cert     TEXT NOT NULL,
    pin      TEXT,
    created  DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE `reports` (
        `id`            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `receiptNum`	INTEGER,
        `timestamp`	datetime NOT NULL,
        `text`          text,
        `type`	INTEGER NOT NULL DEFAULT 0,
        `curfew`	text NOT NULL DEFAULT '00:00',
        `timestampfrom`	datetime NOT NULL DEFAULT '0000-00-00T00:00:00'
);
CREATE INDEX `reports_receiptNum_index` ON `reports` (`receiptNum`);

CREATE TABLE `printerdefs` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	TEXT NOT NULL UNIQUE,
        `definition`	TEXT NOT NULL,
        `mode`	INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE `printers` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	TEXT NOT NULL UNIQUE,
        `printer`	TEXT NOT NULL,
        `definition`	INTEGER NOT NULL DEFAULT 1,
        `mode`	INTEGER NOT NULL DEFAULT 0,
        FOREIGN KEY(`definition`) REFERENCES `printerdefs`(`id`)
);

CREATE TABLE `permissions` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `permKey`	TEXT NOT NULL,
        `permName`	TEXT NOT NULL UNIQUE,
        CONSTRAINT `permKey` UNIQUE (`permKey`)
);

CREATE TABLE `role_perms` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `roleID`	INTEGER NOT NULL,
        `permID`	INTEGER NOT NULL,
        `value`	INTEGER NOT NULL DEFAULT 0,
        `addDate`	datetime NOT NULL,
        CONSTRAINT `roleID` UNIQUE (`roleID`, `permID`)
);

CREATE TABLE `roles` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `roleName`	TEXT NOT NULL UNIQUE,
        CONSTRAINT `roleName` UNIQUE (`roleName`)
);

CREATE TABLE `user_perms` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `userID`	INTEGER NOT NULL,
        `permID`	INTEGER NOT NULL,
        `value`	INTEGER NOT NULL DEFAULT 0,
        `addDate`	datetime NOT NULL,
        CONSTRAINT `userId` UNIQUE (`userID`, `permID`)
);

CREATE TABLE `user_roles` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `userID`	INTEGER NOT NULL,
        `roleID`	INTEGER NOT NULL,
        `addDate`	datetime NOT NULL,
        CONSTRAINT `userId` UNIQUE (`userID`, `roleID`)
);

CREATE TABLE `users` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `username`	TEXT NOT NULL UNIQUE,
        `displayname`	TEXT NOT NULL,
        `password`	TEXT NOT NULL,
        `value`	INTEGER NOT NULL DEFAULT 0,
        `gender`	INTEGER NOT NULL DEFAULT 0,
        `avatar`	TEXT,
        `acskey`	TEXT UNIQUE,
        `addDate`	datetime NOT NULL
);

INSERT INTO `permissions` (ID, permKey, permName) VALUES
(1, 'register_access', 'Zugriff auf die Kasse'),
(2, 'register_r2b', 'Bon in Rechnung umwandeln'),
(3, 'documents_access', 'Zugriff auf Dokumente'),
(4, 'documents_cancellation', 'Dokumente stornieren'),
(5, 'tasks_access', 'Zugriff auf Aufgaben'),
(6, 'tasks_create_eod', 'Tagesabschluss-Aufgabe erstellen'),
(7, 'tasks_create_eom', 'Monatsabschluss-Aufgabe erstellen'),
(8, 'manager_access', 'Zugriff auf Managerbereich'),
(9, 'settings_access', 'Zugriff auf Einstellungen'),
(10, 'settings_view_masterdata', 'Zugriff auf Einstellungen: Stammdaten'),
(11, 'settings_edit_masterdata', 'Einstellungen: Stammdaten bearbeiten'),
(12, 'settings_view_printer', 'Zugriff auf Einstellungen: Drucker'),
(13, 'settings_edit_printer', 'Einstellungen: Drucker bearbeiten'),
(14, 'settings_view_receipt_printer', 'Zugriff auf Einstellungen: BON-Drucker'),
(15, 'settings_edit_receipt_printer', 'Einstellungen: BON-Drucker bearbeiten'),
(16, 'settings_view_receipt', 'Zugriff auf Einstellungen: Kassenbon'),
(17, 'settings_edit_receipt', 'Einstellungen: Kassenbon bearbeiten'),
(18, 'settings_view_receipt_text', 'Zugriff auf Einstellungen: Bontexte'),
(19, 'settings_edit_receipt_text', 'Einstellungen: Bontexte bearbeiten'),
(20, 'settings_view_paths', 'Zugriff auf Einstellungen: Verzeichnispfade'),
(21, 'settings_edit_paths', 'Einstellungen: Verzeichnispfade bearbeiten'),
(22, 'settings_view_extra', 'Zugriff auf Einstellungen: Zusatzdaten'),
(23, 'settings_edit_extra', 'Einstellungen: Zusatzdaten bearbeiten'),
(24, 'settings_view_importserver', 'Zugriff auf Einstellungen: Importserver'),
(25, 'settings_edit_importserver', 'Einstellungen: Importserver bearbeiten'),
(26, 'settings_view_see', 'Zugriff auf Einstellungen: Signatureinheit'),
(27, 'settings_edit_see', 'Einstellungen: Signatureinheit bearbeiten'),
(28, 'admin_access', 'Zugriff auf Administration'),
(29, 'admin_edit_user', 'Benutzer in der Administration bearbeiten'),
(30, 'admin_edit_userroles', 'Benutzerrollen in der Administration bearbeiten'),
(31, 'admin_edit_userperms', 'Benutzerrechte in der Administration bearbeiten'),
(32, 'admin_create_user', 'Benutzer in der Administration erstellen'),
(33, 'admin_delete_user', 'Benutzer in der Administration löschen'),
(34, 'admin_edit_role', 'Rollen in der Administration bearbeiten'),
(35, 'admin_create_role', 'Rollen in der Administration erstellen'),
(36, 'admin_delete_role', 'Rollen in der Administration löschen'),
(37, 'salesinfo_view', 'Zugriff auf Verkaufsinformationen'),
(38, 'import_csv', 'CSV-Daten importieren'),
(39, 'gastro_user_can_change_singleprice', 'Benutzer darf Einzelpreise ändern'),
(40, 'settings_edit_collection_receipt', 'Einstellungen: Sammelrechnung bearbeiten'),
(41, 'settings_edit_receipt_reports', 'Einstellungen: Belegberichte bearbeiten'),
(42, 'gastro_register_access', 'Zugriff auf die Gastro-Kasse'),
(43, 'plugin_run_cashbook', 'Kassenbuch-Plugin ausführen'),
(44, 'plugin_cashbook_access_editbox', 'Zugriff auf Bearbeitungsfeld im Kassenbuch-Plugin'),
(45, 'gastro_void_ticked', 'Artikel in der Gastro zur Stornierung auswählen'),
(46, 'plugin_run_chart', 'Diagramm-Plugin ausführen'),
(47, 'gastro_employee_ticked', 'Mitarbeiterartikel in der Gastro auswählen'),
(48, 'salesinfo_print', 'Verkaufsinformationen drucken'),
(49, 'gastro_advertising_ticked', 'Werbeartikel in der Gastro auswählen'),
(50, 'gastro_private_ticked', 'Privatartikel in der Gastro auswählen'),
(51, 'plugin_run_coupon', 'Coupon-Plugin ausführen'),
(52, 'plugin_coupon_access_editbox', 'Zugriff auf Bearbeitungsfeld im Coupon-Plugin');
