/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "couponsettingswidget.h"
#include "ui_couponsettingswidget.h"

#include "3rdparty/profeatures/profeatures.h"
#include "database.h"

#include <QDateTime>
#include <QDebug>
#include <QFile>
#include <QSqlDatabase>
#include <QSqlError>

#include <QVariant>

CouponSettingsWidget::CouponSettingsWidget(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::CouponSettingsWidget)
{
    ui->setupUi(this);

    QVariant value;
    QString strValue;

    Database::select_globals("coupon_active", value, strValue);
    ui->groupBox->setChecked(value.toBool());

    connect(ui->groupBox, &QGroupBox::toggled, this, &CouponSettingsWidget::updateDatabase);
    connect(ui->savePushButton, &QrkPushButton::clicked, this, &CouponSettingsWidget::save);
    connect(ui->exitPushButton, &QrkPushButton::clicked, this, &CouponSettingsWidget::rejected);
}

CouponSettingsWidget::~CouponSettingsWidget()
{
    delete ui;
}

void CouponSettingsWidget::save()
{

    if (ui->groupBox->isChecked()) {
        if (updateDatabase(true)) Database::insert2globals("coupon_active", 1, QVariant());
    } else {
        Database::insert2globals("coupon_active", 0, QVariant());
    }

    emit saved();
}

bool CouponSettingsWidget::updateDatabase(bool checked)
{
    if (checked) {
        int current_schema = 1;
        return ProFeatures::updatePluginDatabase(
            "coupon", QLatin1String("coupons"), current_schema, ":coupon/sql/coupon");
    }

    return true;
}
