#ifndef QRKCUSTOMDIALOG_H
#define QRKCUSTOMDIALOG_H

#include "qrkcore_global.h"

#include <QDialog>
#include <QMap>

class QRK_EXPORT QrkCustomDialog : public QDialog {
    Q_OBJECT
public:
    explicit QrkCustomDialog(QDialog *parent = nullptr);
    void setValue(const QString &key, const QString &value);
    QString getValue(const QString &key);

signals:
    void valueChanged(const QString &key, const QString &value);

private:
    QMap<QString, QString> m_map;
};

#endif // QRKCUSTOMDIALOG_H
