#include "qrkgastroorderdelegate.h"
#include "database.h"
#include "qbcmath/bcmath.h"

#include <QLocale>
#include <QPainter>

QrkGastroOrderDelegate::QrkGastroOrderDelegate(QObject *parent)
    : QStyledItemDelegate(parent)
{
}

// paint-Methode für benutzerdefiniertes Zeichnen überschreiben
void QrkGastroOrderDelegate::paint(
    QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    if (!painter || !index.isValid() || !index.model()) {
        return;
    }

    if (index.column() == 2) { // Die Spalte, die als Preis formatiert angezeigt werden soll
        // Hole den Wert aus der Spalte 0
        QBCMath quantity(index.model()->data(index.sibling(index.row(), 0), Qt::DisplayRole).toDouble());
        quantity.round(2);

        // Hole den Preiswert und formatiere ihn als Währung
        QBCMath price(index.model()->data(index, Qt::DisplayRole).toDouble());
        price.round(2);

        // Berechne das Ergebnis: quantity * price
        QBCMath total(quantity * price);
        total.round(2);

        // Formatiere das Ergebnis als Währung
        QString sc = Database::getShortCurrency();
        QString formattedTotal = QString("%1%2/%3%2").arg(price.toLocale()).arg(sc).arg(total.toLocale());
        if (quantity.toDouble() == 0.00) formattedTotal = QString("%1%2").arg(price.toLocale()).arg(sc);

        // Zeichne den Text auf die Zelle
        painter->save();
        painter->drawText(option.rect, Qt::AlignVCenter | Qt::AlignRight, formattedTotal);
        painter->restore();
    } else {
        QStyledItemDelegate::paint(painter, option, index);
    }
}
