#include "settingswidget.h"

#include <QCheckBox>
#include <QEvent>
#include <QJsonObject>
#include <QLineEdit>
#include <QMessageBox>

SettingsWidget::SettingsWidget(QWidget *parent)
    : Widget(parent)
{
}

bool SettingsWidget::maybeSave()
{
    if (isModified()) {
        QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, accessibleName(),
            tr("Einige Eigenschaften wurden geändert.\nMöchten Sie die Änderungen "
               "speichern?"),
            QMessageBox::Save | QMessageBox::Cancel);
        if (ret == QMessageBox::Save)
            return true; // save();
        else if (ret == QMessageBox::Cancel)
            return false;
    }
    return true;
}

bool SettingsWidget::isModified()
{
    m_ismodified = m_initialData != m_jsonValues;
    return m_ismodified;
}
