SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";

START TRANSACTION;

RENAME TABLE receipts TO old_receipts_temp;

CREATE TABLE `receipts` (
    `id`            INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `timestamp`     DATETIME NOT NULL,
    `infodate`      DATETIME NOT NULL,
    `receiptNum`    INTEGER DEFAULT NULL,
    `payedBy`       INTEGER NOT NULL DEFAULT 0,
    `gross`         DOUBLE NOT NULL DEFAULT 0,
    `r2b`           INTEGER NOT NULL DEFAULT 0,
    `storno`        INTEGER NOT NULL DEFAULT 0,
    `stornoId`      INTEGER NOT NULL DEFAULT 0,
    `userId`        INTEGER NOT NULL DEFAULT 0,
    `current_hash`  TEXT,
    `previous_hash` TEXT,
    `isprinted`     INTEGER DEFAULT 1,
    `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP())
);

INSERT INTO receipts (
    id, timestamp, infodate, receiptNum, payedBy, gross, r2b, storno, stornoId,
    userId, current_hash, previous_hash, isprinted, unix_timestamp
)
SELECT
    id, timestamp, infodate, receiptNum, payedBy, gross, r2b, storno, stornoId,
    userId, current_hash, previous_hash, isprinted,
    UNIX_TIMESTAMP(timestamp)
FROM old_receipts_temp;

DROP TABLE old_receipts_temp;


DROP INDEX IF EXISTS `reports_receiptNum_index` ON `reports`;
RENAME TABLE reports TO old_reports_temp;

CREATE TABLE `reports` (
    `id`            INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `receiptNum`    INTEGER,
    `timestamp`     DATETIME NOT NULL,
    `text`          TEXT,
    `type`          INTEGER NOT NULL DEFAULT 0,
    `curfew`        TEXT NOT NULL DEFAULT '00:00',
    `timestampfrom` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP())
);
CREATE INDEX `reports_receiptNum_index` ON `reports` (`receiptNum`);

INSERT INTO reports (
    id, receiptNum, timestamp, text, type, curfew, timestampfrom, unix_timestamp
)
SELECT
    id, receiptNum, timestamp, text, type, curfew, timestampfrom,
    UNIX_TIMESTAMP(timestamp)
FROM old_reports_temp;

DROP TABLE old_reports_temp;


RENAME TABLE tickets TO old_tickets_temp;

CREATE TABLE `tickets` (
    `id`            INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `open`          TINYINT(1) NOT NULL DEFAULT 1,
    `timestamp`     DATETIME NOT NULL,
    `tableId`       INT(11) NOT NULL,
    `payedBy`       INT(11) NOT NULL DEFAULT 0,
    `guestname`     TEXT,
    `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP())
);

INSERT INTO tickets (
    id, open, timestamp, tableId, payedBy, guestname, unix_timestamp
)
SELECT
    id, open, timestamp, tableId, payedBy, guestname,
    UNIX_TIMESTAMP(timestamp)
FROM old_tickets_temp;

DROP TABLE old_tickets_temp;

RENAME TABLE journal TO old_journal_temp;

CREATE TABLE `journal` (
    `id`                INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `version`           TEXT NOT NULL,
    `cashregisterid`    TEXT NOT NULL,
    `datetime`          DATETIME NOT NULL,
    `data`              TEXT,
    `checksum`          TEXT,
    `userId`            INTEGER NOT NULL DEFAULT 0,
    `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP())
);

INSERT INTO journal (
    id, version, cashregisterid, datetime, data, checksum, userId, unix_timestamp
)
SELECT
    id, version, cashregisterid, datetime, data, checksum, userId,
    UNIX_TIMESTAMP(datetime)
FROM old_journal_temp;

DROP TABLE old_journal_temp;

RENAME TABLE history TO old_history_temp;

CREATE TABLE `history` (
    `id`            INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `datetime`      DATETIME NOT NULL,
    `data`          TEXT,
    `userId`        INTEGER NOT NULL DEFAULT 0,
    `unix_timestamp` INTEGER DEFAULT (UNIX_TIMESTAMP())
);

INSERT INTO history (
    id, datetime, data, userId, unix_timestamp
)
SELECT
    id, datetime, data, userId,
    UNIX_TIMESTAMP(datetime)
FROM old_history_temp;

DROP TABLE old_history_temp;

COMMIT;

SET FOREIGN_KEY_CHECKS=1;
