BEGIN TRANSACTION;

ALTER TABLE receipts RENAME TO old_receipts_temp;
ALTER TABLE tickets RENAME TO old_tickets_temp;
ALTER TABLE journal RENAME TO old_journal_temp;
ALTER TABLE history RENAME TO old_history_temp;
ALTER TABLE reports RENAME TO old_reports_temp;

ALTER TABLE orders RENAME TO old_orders_temp;
ALTER TABLE ticketorders RENAME TO old_ticketorders_temp;
ALTER TABLE orderextras RENAME TO old_orderextras_temp;

CREATE TABLE "receipts" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "timestamp"     datetime NOT NULL,
    "infodate"      datetime NOT NULL,
    "receiptNum"    INTEGER DEFAULT NULL,
    "payedBy"       INTEGER NOT NULL DEFAULT '0',
    "gross"         double NOT NULL DEFAULT '0',
    "r2b"           INTEGER NOT NULL DEFAULT '0',
    "storno"        INTEGER NOT NULL DEFAULT '0',
    "stornoId"      INTEGER NOT NULL DEFAULT '0',
    "userId"        INTEGER NOT NULL DEFAULT '0',
    "current_hash"  TEXT,
    "previous_hash" TEXT,
    "isprinted"     INTEGER DEFAULT '1',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

CREATE TABLE "tickets" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "open"          tinyint(1) NOT NULL DEFAULT '1',
    "timestamp"     datetime NOT NULL,
    "tableId"       int(11) NOT NULL,
    "payedBy"       int(11) NOT NULL DEFAULT '0',
    "guestname"     TEXT,
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

CREATE TABLE "journal" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "version"       text NOT NULL,
    "cashregisterid" text NOT NULL,
    "datetime"      datetime NOT NULL,
    "data"          text,
    "checksum"      text,
    "userId"        INTEGER NOT NULL DEFAULT '0',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

CREATE TABLE "history" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "datetime"      datetime NOT NULL,
    "data"          text,
    "userId"        INTEGER NOT NULL DEFAULT '0',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

CREATE TABLE "reports" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "receiptNum"    INTEGER,
    "timestamp"     datetime NOT NULL,
    "text"          text,
    "type"          INTEGER NOT NULL DEFAULT 0,
    "curfew"        text NOT NULL DEFAULT '00:00',
    "timestampfrom" datetime NOT NULL DEFAULT '0000-00-00T00:00:00',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

CREATE TABLE `orders` (
    `id`       INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `receiptId` INTEGER NOT NULL,
    `product` INTEGER NOT NULL,
    `count`    double NOT NULL DEFAULT '1',
    `discount` double NOT NULL DEFAULT '0',
    `net`      double NOT NULL,
    `gross`    double NOT NULL,
    `tax`      double NOT NULL DEFAULT '0.0',
    CONSTRAINT `product` FOREIGN KEY(`product`) REFERENCES `products` ( `id` ),
    FOREIGN KEY(`receiptId`) REFERENCES `receipts` (`id`)
);

CREATE TABLE `ticketorders` (
    `id` INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    `ticketId` INTEGER NOT NULL,
    `product` INTEGER NOT NULL REFERENCES `products` (`id`),
    `count` int(11) NOT NULL DEFAULT '1',
    `gross` double NOT NULL,
    `printed` int(11) NOT NULL DEFAULT '0',
    FOREIGN KEY(`ticketId`) REFERENCES `tickets` (`id`)
);

CREATE TABLE "orderextras" (
    "orderId"   INTEGER NOT NULL,
    "ticketId"  INTEGER,
    "type"      INTEGER,
    "product"   INTEGER NOT NULL,
    FOREIGN KEY("orderId") REFERENCES "ticketorders"("id"),
    FOREIGN KEY("product") REFERENCES "products"("id"),
    FOREIGN KEY("ticketId") REFERENCES "tickets"("id")
);

INSERT INTO receipts (id, timestamp, infodate, receiptNum, payedBy, gross, r2b, storno, stornoId, userId, current_hash, previous_hash, isprinted, unix_timestamp)
SELECT id, timestamp, infodate, receiptNum, payedBy, gross, r2b, storno, stornoId, userId, current_hash, previous_hash, isprinted, unix_timestamp FROM old_receipts_temp;

INSERT INTO tickets (id, open, timestamp, tableId, payedBy, guestname, unix_timestamp)
SELECT id, open, timestamp, tableId, payedBy, guestname, strftime('%s', timestamp) FROM old_tickets_temp;

INSERT INTO journal (id, version, cashregisterid, datetime, data, checksum, userId, unix_timestamp)
SELECT id, version, cashregisterid, datetime, data, checksum, userId, unix_timestamp FROM old_journal_temp;

INSERT INTO history (id, datetime, data, userId, unix_timestamp)
SELECT id, datetime, data, userId, unix_timestamp FROM old_history_temp;

INSERT INTO reports (id, receiptNum, timestamp, text, type, curfew, timestampfrom, unix_timestamp)
SELECT id, receiptNum, timestamp, text, type, curfew, timestampfrom, unix_timestamp FROM old_reports_temp;

INSERT INTO orders (id, receiptId, product, count, discount, net, gross, tax)
SELECT id, receiptId, product, count, discount, net, gross, tax FROM old_orders_temp;

INSERT INTO ticketorders (id, ticketId, product, count, gross, printed)
SELECT id, ticketId, product, count, gross, printed FROM old_ticketorders_temp;

INSERT INTO orderextras (orderId, ticketId, type, product)
SELECT orderId, ticketId, type, product FROM old_orderextras_temp;

DROP TABLE old_receipts_temp;
DROP TABLE old_tickets_temp;
DROP TABLE old_journal_temp;
DROP TABLE old_history_temp;
DROP TABLE old_reports_temp;
DROP TABLE old_orders_temp;
DROP TABLE old_ticketorders_temp;
DROP TABLE old_orderextras_temp;

DROP INDEX IF EXISTS `orderdescs_orderId_index`;
DROP INDEX IF EXISTS `orders_receiptId_index`;
DROP INDEX IF EXISTS `orders_ticketId_index`;
DROP INDEX IF EXISTS `receipts_stornoId_index`;
DROP INDEX IF EXISTS `receiptspay_index`;

CREATE INDEX `orderdescs_orderId_index` ON `orderdescs` (`orderId`);
CREATE INDEX `orders_receiptId_index` ON `orders` (`receiptId`);
CREATE INDEX `orders_ticketId_index` ON `ticketorders` (`ticketId`);
CREATE INDEX `receipts_stornoId_index` ON `receipts` (`stornoId`);
CREATE INDEX `receiptspay_index` ON `receiptspay` (`receiptNum`);

COMMIT;
