#include "multilistcombobox.h"

#include <QDebug>
#include <QtWidgets>

MultiListComboBox::MultiListComboBox(QWidget *parent)
    : QComboBox(parent)
{
    setEditable(true);

    m_displayText = "";
    m_model = new QStandardItemModel;
    updateText();

    connect(m_model, &QStandardItemModel::itemChanged, this, &MultiListComboBox::update);
}

void MultiListComboBox::addItem(const QString &text)
{
    int row = m_model->rowCount();
    QStandardItem *item = new QStandardItem();
    item->setText(text);
    item->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled);
    item->setData(Qt::Unchecked, Qt::CheckStateRole);
    m_model->setItem(row, 0, item);
    this->setModel(m_model);
}

void MultiListComboBox::addItems(const QStringList &texts)
{
    for (int i = 0; i < texts.count(); i++) {
        addItem(texts.at(i));
    }
}

QStringList MultiListComboBox::getCheckedItems() const
{
    QStringList checkedItems;

    for (int i = 0; i < m_model->rowCount(); i++) {
        if (m_model->item(i, 0)->checkState() == Qt::Checked) {
            checkedItems << m_model->item(i, 0)->text();
        }
    }

    return checkedItems;
}

void MultiListComboBox::setCheckedItems(const QStringList &items)
{
    for (int i = 0; i < items.count(); i++) {
        int index = findText(items.at(i));

        if (index != -1) {
            m_model->item(index)->setData(Qt::Checked, Qt::CheckStateRole);
        }
    }

    update();
}

void MultiListComboBox::updateText()
{
    qDebug() << "Function Name: " << Q_FUNC_INFO << " Text: " << m_displayText;

    if (isEditable()) lineEdit()->setText(m_displayText);
}

void MultiListComboBox::update()
{
    m_displayText = "";

    for (int i = 0; i < m_model->rowCount(); i++) {
        if (m_model->item(i, 0)->checkState() == Qt::Checked) {
            m_displayText = m_displayText + m_model->item(i, 0)->text() + "; ";
        }
    }

    QTimer::singleShot(0, this, &MultiListComboBox::updateText);
    emit checkedItemsChanged();
}
