#ifndef CSQLQUERY_H
#    define CSQLQUERY_H

#    include "globals_ckvsoft.h"

#    include <QSqlDatabase>
#    include <QSqlQuery>
#    include <QString>
#    undef QSQLQUERY_DEPRECATED

class CKVSOFT_EXPORT CSqlQuery : public QSqlQuery {
public:
    explicit CSqlQuery(const QSqlDatabase &db, const QString &pretty_funktion);
    CSqlQuery();

    bool exec();
    bool exec(const QString &queryStr);
    QString getLastExecutedQuery() const;
    QString m_pretty_funktion;
    void setShowError(bool show);
    void setCriticalError(bool show);

private:
    bool m_show_error = true;
    bool m_is_critical = false;
};

#endif // CSQLQUERY_H
#define QSQLQUERY_DEPRECATED [[deprecated(QSQLQUERY_ERROR)]]
