#include "qrkcustomdialog.h"

#include <QDebug>

QrkCustomDialog::QrkCustomDialog(QDialog *parent)
    : QDialog { parent }
{
    setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint);
}

void QrkCustomDialog::setValue(const QString &key, const QString &value)
{
    qDebug() << "Function Name: " << Q_FUNC_INFO << "key: " << key << " value: " << value;

    m_map.insert(key, value);
    emit valueChanged(key, value);
}

QString QrkCustomDialog::getValue(const QString &key)
{
    QString value = m_map.value(key);
    qDebug() << "Function Name: " << Q_FUNC_INFO << "key: " << key << " value: " << value;

    return value;
}
