#include "profeaturesprint.h"
#include "database.h"
#include "qrksettings.h"
#include "qrktimedmessagebox.h"

#include <QJsonObject>

ProFeaturesPrint::ProFeaturesPrint()
{
}

bool ProFeaturesPrint::OptionalReciptPrint(QJsonObject &data)
{
    QrkSettings settings;

    bool print = settings.value("optionalreceiptprint", false).toBool();
    bool useDialog = settings.value("optionalReceiptPrintDialog", false).toBool();
    if (print) {
        int value = settings.value("optionalreceiptprintvalue", 35).toInt();
        double sum = 0;
        if (data.contains("sum")) {
            sum = data.value("sum").toDouble();
        }

        if (sum < value) {
            if (useDialog)
                return askPrintReceipt(sum, value);
            else
                return false;
        }
    }

    return true;
}

bool ProFeaturesPrint::askPrintReceipt(double receiptSum, double thresholdValue)
{
    QString messageText = tr(
        "Die Belegsumme beträgt %1 %3 und liegt unter dem festgelegten Wert von %2 %3.\nMöchten Sie den Bon trotzdem drucken?")
                              .arg(receiptSum, 0, 'f', 2)
                              .arg(thresholdValue, 0, 'f', 2)
                              .arg(Database::getShortCurrency());

    QrkTimedMessageBox messageBox(10, QMessageBox::Question, tr("Druckfrage"), messageText,
        QMessageBox::Yes | QMessageBox::No | QMessageBox::Default);

    messageBox.setDefaultButton(QMessageBox::No);
    messageBox.setButtonText(QMessageBox::Yes, QObject::tr("Ja"));
    messageBox.setButtonText(QMessageBox::No, QObject::tr("Nein"));

    int result = messageBox.exec();

    return result == QMessageBox::Yes;
}
